import _mergeJSXProps from "babel-helper-vue-jsx-merge-props";
export default {
  name: 'GiftIcon',
  props: {
    size: {
      type: String,
      default: '24',
      validator: function validator(s) {
        return !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x';
      }
    }
  },
  functional: true,
  render: function render(h, ctx) {
    var size = ctx.props.size.slice(-1) === 'x' ? ctx.props.size.slice(0, ctx.props.size.length - 1) + 'em' : parseInt(ctx.props.size) + 'px';
    var attrs = ctx.data.attrs || {};
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    ctx.data.attrs = attrs;
    return h("svg", _mergeJSXProps([{
      attrs: {
        xmlns: "http://www.w3.org/2000/svg",
        width: "24",
        height: "24",
        viewBox: "0 0 24 24",
        fill: "none",
        stroke: "currentColor",
        "stroke-width": "2",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      },
      "class": "feather feather-gift"
    }, ctx.data]), [h("polyline", {
      attrs: {
        points: "20 12 20 22 4 22 4 12"
      }
    }), h("rect", {
      attrs: {
        x: "2",
        y: "7",
        width: "20",
        height: "5"
      }
    }), h("line", {
      attrs: {
        x1: "12",
        y1: "22",
        x2: "12",
        y2: "7"
      }
    }), h("path", {
      attrs: {
        d: "M12 7H7.5a2.5 2.5 0 0 1 0-5C11 2 12 7 12 7z"
      }
    }), h("path", {
      attrs: {
        d: "M12 7h4.5a2.5 2.5 0 0 0 0-5C13 2 12 7 12 7z"
      }
    })]);
  }
};