import _mergeJSXProps from "babel-helper-vue-jsx-merge-props";
export default {
  name: 'PenToolIcon',
  props: {
    size: {
      type: String,
      default: '24',
      validator: function validator(s) {
        return !isNaN(s) || s.length >= 2 && !isNaN(s.slice(0, s.length - 1)) && s.slice(-1) === 'x';
      }
    }
  },
  functional: true,
  render: function render(h, ctx) {
    var size = ctx.props.size.slice(-1) === 'x' ? ctx.props.size.slice(0, ctx.props.size.length - 1) + 'em' : parseInt(ctx.props.size) + 'px';
    var attrs = ctx.data.attrs || {};
    attrs.width = attrs.width || size;
    attrs.height = attrs.height || size;
    ctx.data.attrs = attrs;
    return h("svg", _mergeJSXProps([{
      attrs: {
        xmlns: "http://www.w3.org/2000/svg",
        width: "24",
        height: "24",
        viewBox: "0 0 24 24",
        fill: "none",
        stroke: "currentColor",
        "stroke-width": "2",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      },
      "class": "feather feather-pen-tool"
    }, ctx.data]), [h("path", {
      attrs: {
        d: "M12 19l7-7 3 3-7 7-3-3z"
      }
    }), h("path", {
      attrs: {
        d: "M18 13l-1.5-7.5L2 2l3.5 14.5L13 18l5-5z"
      }
    }), h("path", {
      attrs: {
        d: "M2 2l7.586 7.586"
      }
    }), h("circle", {
      attrs: {
        cx: "11",
        cy: "11",
        r: "2"
      }
    })]);
  }
};