<p align="center">
  <a href="https://lusaxweb.github.io/vuesax/">
<img width="40%" src="https://raw.githubusercontent.com/lusaxweb/vuesax/master/public/vuesax-logo-beta.png" alt="vuesax" />
<img src="https://raw.githubusercontent.com/lusaxweb/vuesax/master/public/vuesax-components.gif" alt="vuesax" />
   </a>
  </p>

  </br>

  <p align="center">
  <a href="https://travis-ci.org/lusaxweb/vuesax">
    <img src="https://img.shields.io/travis/lusaxweb/vuesax.svg" alt="travis ci badge">
  </a>
  <a href="https://www.npmjs.com/package/vuesax">
    <img src="https://img.shields.io/npm/dm/vuesax.svg" alt="Downloads">
  </a>
  <a href="https://www.npmjs.com/package/vuesax">
    <img src="https://img.shields.io/npm/v/vuesax.svg" alt="Version">
  </a>
  <a href="https://www.npmjs.com/package/vuesax"><img src="https://img.shields.io/npm/l/vuesax.svg" /></a>
  <a href="https://discord.gg/6AZNXEa">
    <img src="https://discordapp.com/api/guilds/467198491920433153/widget.png" alt="Chat">
  </a>
</p>

<h2 align="center">Supporting through Patreon</h2>

Vuesax is an open source [MIT](https://raw.githubusercontent.com/lusaxweb/vuesax/master/LICENSE) project if you want to contribute to keep improving, If you are interested in supporting this project, please consider becoming a patron. [Patron](https://www.patreon.com/bePatron?c=1567892)

<p align="center">
  <a href="https://www.patreon.com/bePatron?c=1567892">
    <img src="https://c5.patreon.com/external/logo/become_a_patron_button.png" alt="Become a Patron" />
  </a>
</p>

<p align="center"><b>Silver</b></p>

<p align="center">
  <a href="https://tipe.io/">
    <img width="20%" src="https://raw.githubusercontent.com/lusaxweb/vuesax/master/docs/.vuepress/public/tipe.png" alt="Tipe" />
   </a>
  <a href="https://bitsrc.io/">
    <img width="20%" src="https://raw.githubusercontent.com/lusaxweb/vuesax/master/docs/.vuepress/public/bit-share-code.png" alt="Bit">
  </a>
  <a href="https://www.wrappixel.com/?ref=102">
    <img width="20%" src="https://raw.githubusercontent.com/lusaxweb/vuesax/master/docs/.vuepress/public/wrappixel-logo.png" alt="Bit">
  </a>
 </p>

## Introduction

[Vuesax](https://lusaxweb.github.io/vuesax/) is a framework of components based on [vue.js](https://vuejs.org/), it is a framework that is designed from scratch to be incrementally adoptable.

The framework is focused on facilitating the development of applications, improving the design of the same without removing the necessary functionality. we want all the components to be independent in colors, shapes and design for a freedom that we like all front-end but without losing the speed of creation and production.

## Vuesax 4 (alpha)

We are already creating vuesax 4 you can see the progress [here](https://vuesax.com/) and if you want to help in the development you can do it [here](https://github.com/lusaxweb/vuesax-next)

## Support the project ⭐

If you feel awesome and want to support us in a small way, please consider starring and sharing the repo! This helps us getting known and grow the community. 🙏

<img src="https://raw.githubusercontent.com/lusaxweb/vuesax/master/public/github-vuesax-star.gif" alt="vuesax-star" />

## Links

- 📘 [Documentation](https://lusaxweb.github.io/vuesax/)
- 📚 [Blog](https://lusaxweb.github.io/vuesax-blog/)
- 🐦 Twitter: [@vuesax](https://twitter.com/vuesax)
- 💬 Chat: [Discord](https://discord.gg/6AZNXEa)
- 🎲 template: [Codepen](https://codepen.io/lusaxweb/pen/mxMKYr)
- 📰 Tutorial Implement: [DevAwesome](https://lusaxweb.github.io/devAwesome/#/article/-LPDgBxyylgg9h194wuE)
- 🔧[vuesax-helper](https://marketplace.visualstudio.com/items?itemName=vuesax.vscode-vuesax-helper): is a VS Code extension for Vuesax

## Components

- [Buttons](https://lusaxweb.github.io/vuesax/components/) - [v4](https://vuesax.com/docs/components/)
- [Selects](https://lusaxweb.github.io/vuesax/components/selects.html) - [v4](https://vuesax.com/docs/components/Select.html)
- [Notifications](https://lusaxweb.github.io/vuesax/components/notifications.html) - [v4](https://vuesax.com/docs/components/Notification.html)
- [Switch](https://lusaxweb.github.io/vuesax/components/switch.html) - [v4](https://vuesax.com/docs/components/Switch.html)
- [CheckBox](https://lusaxweb.github.io/vuesax/components/checkbox.html) - [v4](https://vuesax.com/docs/components/Checkbox.html)
- [Radio](https://lusaxweb.github.io/vuesax/components/radio.html) - [v4](https://vuesax.com/docs/components/Radio.html)
- [Input](https://lusaxweb.github.io/vuesax/components/input.html) - [v4](https://vuesax.com/docs/components/Input.html)
- [Dialogs](https://lusaxweb.github.io/vuesax/components/dialog.html)
- [Tabs](https://lusaxweb.github.io/vuesax/components/tabs.html)
- [Slider](https://lusaxweb.github.io/vuesax/components/slider.html)
- [InputNumber](https://lusaxweb.github.io/vuesax/components/number.html)
- [Tooltip](https://lusaxweb.github.io/vuesax/components/tooltip.html) - [v4](https://vuesax.com/docs/components/Tooltip.html)
- [Upload](https://lusaxweb.github.io/vuesax/components/upload.html)
- [Loading](https://lusaxweb.github.io/vuesax/components/loading.html) - [v4](https://vuesax.com/docs/components/Loading.html)
- [Popup](https://lusaxweb.github.io/vuesax/components/popup.html)
- [Avatar](https://lusaxweb.github.io/vuesax/components/avatar.html) - [v4](https://vuesax.com/docs/components/Avatar.html)
- [Breadcrumb](https://lusaxweb.github.io/vuesax/components/breadcrumb.html)
- [Alert](https://lusaxweb.github.io/vuesax/components/alert.html) - [v4](https://vuesax.com/docs/components/Alert.html)
- [Divider](https://lusaxweb.github.io/vuesax/components/divider.html)
- [Chip](https://lusaxweb.github.io/vuesax/components/chip.html)
- [Progress](https://lusaxweb.github.io/vuesax/components/progress.html)
- [Card](https://lusaxweb.github.io/vuesax/components/card.html)
- [List](https://lusaxweb.github.io/vuesax/components/list.html)
- [Pagination](https://lusaxweb.github.io/vuesax/components/pagination.html)
- [Topbar](https://lusaxweb.github.io/vuesax/components/topbar.html)
- [SideBar](https://lusaxweb.github.io/vuesax/components/sideBar.html)
- [DropDown](https://lusaxweb.github.io/vuesax/components/dropDown.html)
- [Table](https://lusaxweb.github.io/vuesax/components/table.html)
- [Textarea](https://lusaxweb.github.io/vuesax/components/textarea.html)
- [Collapse](https://lusaxweb.github.io/vuesax/components/collapse.html)
- [Images](https://lusaxweb.github.io/vuesax/components/images.html)

## Browser Support
Recent versions of **Firefox**, **Chrome**, **Edge**, **Opera** and **Safari**. **IE11+**

## Quick-start CDN

```html
<!DOCTYPE html>
<html>
<head>
  <link href="https://cdn.jsdelivr.net/npm/vuesax/dist/vuesax.css" rel="stylesheet">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, minimal-ui">
</head>
<body>
  <div id="app">
    <vs-button vs-type="filled">Hello World</vs-button>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/vue/dist/vue.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/vuesax/dist/vuesax.umd.js"></script>
  <script>
    new Vue({
      el: '#app'
    })
  </script>
</body>
</html>
```

## CDN Links

- https://cdn.jsdelivr.net/npm/vuesax/dist/vuesax.umd.js
- https://cdn.jsdelivr.net/npm/vuesax/dist/vuesax.css

# Install inside a NPM project
``` bash
# npm
npm install vuesax
```

``` bash
# yarn
yarn add vuesax
```

## Use

### All components

```javascript
import Vue from 'vue'
import Vuesax from 'vuesax'

import 'vuesax/dist/vuesax.css'
Vue.use(Vuesax)
```

### Or use individual components:

```javascript
import Vue from 'vue'
import { vsButton, vsSelect, vsPopup } from 'vuesax'
import 'vuesax/dist/vuesax.css'

Vue.use(vsButton)
Vue.use(vsSelect)
Vue.use(vsPopup)
```

## Contribution
Please make sure to read the [Contributing Guide](https://raw.githubusercontent.com/lusaxweb/vuesax/master/CONTRIBUTING.md) before making a pull request.

## Lusaxweb

This library was created and is supported by [Lusaxweb](http://lusaxweb.net/)

## License

[MIT](https://raw.githubusercontent.com/lusaxweb/vuesax/master/LICENSE)
